# Runner

Runner はスクリプト処理のフロントエンドアプリケーションである。

本アプリケーションを使うことで、バッチファイルや python コードなどで作成されたコマンドラインユーザーインターフェースのスクリプトに対して、グラフィカルユーザーインターフェースでパラメータを指定することができる。

## 起動に必要なランタイム

アプリケーションの実行には.NET 8.0 が必要となる。

[.NET 8.0 (Linux、macOS、Windows) をダウンロードする](https://dotnet.microsoft.com/ja-jp/download/dotnet/8.0)

## スクリプトの定義方法

`ファイル`-`設定`の`スクリプト ディレクトリ`で指定されているパスに`*.definition.json`としてスクリプトの定義を記述する。

以下はスクリプトの定義の例である。

```json
{
  // スクリプトの名前を定義する。
  "name": "Rename files",
  // スクリプトの説明を定義する。
  "description": "ファイルをリネームする",
  // スクリプトを分類するタグを定義する。
  "tags": ["Tools"],
  // スクリプト実行時のコマンドを定義する。
  "command": ".\\run_python.bat",
  // コマンドの引数を定義する。(『パラメータ群の受け渡し方について』も参照すること)
  "arguments": ["-m", "rename_files", "{parametersJsonFileName}"],
  // パラメータを定義する。(後述)
  // パラメータを定義するとアプリケーション上でユーザーがパラメータを入力できるようになる。
  "parameters": [
    {
      // パラメータの名前を定義する。
      "name": "filenames",
      // パラメータの種類を定義する。
      "type": "files",
      // パラメータの初期値を定義する。
      "value": "",
      // パラメータの種類に応じた詳細のパラメータを定義する。
      "recursive": true,
      // パラメータの説明を定義する。
      "description": "ファイル名を指定する"
    },
    {
      "name": "format",
      "type": "text",
      "value": "${i}.${ext}",
      "description": "フォーマットを指定する (${filename}: ファイル名, ${i}: 連番, ${ext}: 拡張子(ピリオドを含まない)"
    },
    {
      "name": "digits",
      "type": "int",
      "value": 2,
      "description": "桁数"
    },
    {
      "name": "start",
      "type": "int",
      "value": 1,
      "description": "初期値"
    }
  ]
}
```

## パラメータの種類について

パラメータは`type`を指定することで、ユーザーの入力方法を決めることができる。

### text

1 行だけ入力可能のテキストボックスをユーザーに提示する。

```json
{
  "name": "sample",
  "type": "text",
  "value": "default value",
  "description": "The description of parameter"
}
```

### textarea

複数行入力可能のテキストエリアをユーザーに提示する。

```json
{
  "name": "sample",
  "type": "textarea",
  "value": "default value\ndefault value",
  "description": "The description of parameter"
}
```

### int

32 ビット整数値入力可能のテキストボックスをユーザーに提示する。

```json
{
  "name": "sample",
  "type": "int",
  "value": 0,
  "min": -100,
  "max": 100,
  "description": "The description of parameter"
}
```

### file

開くファイル 1 つのパスを指定可能のテキストボックスをユーザーに提示する。

テキストボックス上にファイルをドロップすることでパスを指定することができる。

```json
{
  "name": "sample",
  "type": "file",
  "value": "",
  "description": "The description of parameter"
}
```

### files

開く複数ファイルのパスを指定可能のテキストエリアをユーザーに提示する。

テキストボックス上にファイルをドロップすることでパスを追加することができる。

```json
{
  "name": "sample",
  "type": "files",
  "value": "",
  "recursive": false, // ドロップ時にディレクトリを再帰的に検索する場合trueを設定する
  "additional": false, // ドロップ時に行追加する場合trueを設定する
  "description": "The description of parameter"
}
```

### directory

ディレクトリのパス 1 つを指定可能のテキストボックスをユーザーに提示する。

```json
{
  "name": "sample",
  "type": "directory",
  "value": "",
  "description": "The description of parameter"
}
```

### boolean

ブール値を指定可能のチェックボックスをユーザーに提示する。

```json
{
  "name": "sample",
  "type": "boolean",
  "value": false,
  "description": "The description of parameter"
}
```

### select

単一の文字列を指定可能のコンボボックスをユーザーに提示する。

文字列の選択肢は`options`で定義できる。

```json
{
  "name": "sample",
  "type": "select",
  "value": "option2",
  "options": ["option1", "option2", "option3"],
  "description": "The description of parameter"
}
```

### date

日付の選択をユーザーに提示する。

`value`は`"YYYY-MM-DDT00:00:00"`の形式で指定する。

```json
{
  "name": "sample",
  "type": "date",
  "value": "2023-01-01T00:00:00",
  "description": "The description of parameter"
}
```

## パラメータ群の受け渡し方について

コマンドへパラメータ群を受け渡す方法は 3 通りある。

### parameters.json のパスをコマンドライン引数に渡す方法

パラメータ群はコマンド実行前に`parameters.json`として書き出される。
`definitions.json`内の`arguments`に`{parametersJsonFileName}`を記述することでコマンドに`parameters.json`のパスを渡すことができる。

### パラメータ群の JSON をコマンドライン引数にわたす方法

`definitions.json`内の`arguments`に`{parametersJson}`を記述することでコマンドにパラメータ群の JSON を渡すことができる。

### パラメータをコマンドライン引数に渡す方法

`definitions.json`内の`arguments`に`{パラメータのname}`を記述することでコマンドにパラメータを渡すことができる。

## サンプルについて

本アプリケーションはスクリプトがないと使い方が分かりにくいので、サンプルのスクリプトをいくつか同梱している。

サンプルはどれも Python を使ったものであり、どれも実行環境に Python がインストールされている前提である。
