import json
import os
import subprocess
import sys
from pathlib import Path


def main() -> None:
    # パラメータを読み込む
    parameters = json.loads(Path(sys.argv[1]).read_text(encoding="utf-8", errors="replace"))

    if len(parameters["filenames"]) <= 0:
        raise Exception("変換したい画像のパスを指定してください。")
    if not os.path.isfile(parameters["bin"]):
        raise Exception("cwebp.exeが見つかりませんでした。正しいパスを指定してください。")

    for i, filename in enumerate(parameters["filenames"]):
        print(f"[{i + 1}/{len(parameters['filenames'])}] Converting {filename}")

        output_filename = os.path.splitext(filename)[0] + ".webp"

        if parameters["mode"] == "lossy (quality=75)":
            print("lossy (quality=75)")
            subprocess.run([parameters["bin"], "-q", "75", filename, "-o", output_filename])
        elif parameters["mode"] == "lossy (quality=50)":
            print("lossy (quality=75)")
            subprocess.run([parameters["bin"], "-q", "50", filename, "-o", output_filename])
        else:
            print("lossless")
            subprocess.run([parameters["bin"], "-lossless", filename, "-o", output_filename])


if __name__ == "__main__":
    try:
        main()
        sys.exit(0)
    except Exception as e:
        print(e, file=sys.stderr)
        input()
        sys.exit(1)
