import json
import os
import subprocess
import sys
from pathlib import Path


def main() -> None:
    # パラメータを読み込む
    parameters = json.loads(Path(sys.argv[1]).read_text(encoding="utf-8", errors="replace"))

    __urls = list(filter(lambda x: len(x) != 0, parameters["urls"].split("\n")))

    if len(__urls) <= 0:
        raise Exception("URLを指定してください。")
    if not os.path.isfile(parameters["bin"]):
        raise Exception("yt-dlp.exeが見つかりませんでした。正しいパスを指定してください。")
    if parameters["destination"] == "" or not os.path.isdir(parameters["destination"]):
        raise Exception("正しい保存先を指定してください。")

    for __url in __urls:
        args = [parameters["bin"], __url]
        if parameters["audioOnly"]:
            args.insert(1, "-x")
        subprocess.run(args, cwd=parameters["destination"])


if __name__ == "__main__":
    try:
        main()
        sys.exit(0)
    except Exception as e:
        print(e, file=sys.stderr)
        input()
        sys.exit(1)
