import json
import os
import sys
from functools import reduce
from pathlib import Path


class Result:
    def __init__(self, before: str, after: str):
        self.before = before
        self.after = after


def main() -> None:
    # パラメータを読み込む
    parameters = json.loads(Path(sys.argv[1]).read_text(encoding="utf-8", errors="replace"))

    # ファイルパス
    filepaths = parameters["filenames"]
    if len(filepaths) <= 0:
        raise Exception("ファイルパスを指定してください。")

    # フォーマット
    __format: str = parameters["format"]
    if len(__format) <= 0:
        raise Exception("フォーマットを指定してください。")

    # 桁数
    digits = int(parameters["digits"])

    # 初期値
    start = int(parameters["start"])

    if len(filepaths) <= 0:
        raise Exception("filepaths required")

    results: list[Result] = []

    # 処理後のファイル名を計算する
    for i, filepath in enumerate(filepaths):
        dirname = os.path.dirname(filepath)
        filename, ext = os.path.splitext(filepath)
        new_filename = __format.replace("${filename}", filename).replace("${ext}", ext[1:]).replace("${i}", str(i + start).zfill(digits))
        results.append(Result(filepath, os.path.join(dirname, new_filename)))

    # 画面に表示してユーザーにこれで良いか問い合わせる
    filenames = map(lambda x: os.path.basename(x), filepaths)
    max_filename_length = len(reduce(lambda x, y: x if len(x) > len(y) else y, filenames))
    for result in results:
        print(f"{os.path.basename(result.before).ljust(max_filename_length)} -> {os.path.basename(result.after)}")

    print("\nOK? (y/N)")
    confirm = input()
    if confirm != "y" and confirm != "Y":
        # y以外だったら中断する
        return

    # リネームを行う
    for result in results:
        os.rename(result.before, result.after)


if __name__ == "__main__":
    try:
        main()
        sys.exit(0)
    except Exception as e:
        print(e, file=sys.stderr)
        input()
        sys.exit(1)
